/*************************************************************************************************
 *
 *   Copyright (c) Hilscher GmbH. All Rights Reserved.
 *
 *************************************************************************************************/
/**
 * @file CoE_Application.h
 *
 * @brief This file contains declaration of bus specific types and functions.
 * In this case it relates to CANopen over EtherCAT protocol.
 *
 * @author R. Walter (basis: E. Ott)
 *
 */

#ifndef __COE_APPLICATION_H
#define __COE_APPLICATION_H

#include "TLR_Types.h"
#include "TLR_Packet.h"

#include "Application.h"

#include "EcsV4_Public.h"
#include "EcsV4_Legacy.h"
#include "OdV3_Public.h"

#include <malloc.h>


#ifdef __cplusplus
  extern "C" {
#endif  /* _cplusplus */


/**
 * @addtogroup CoE
 * @{
 */

/* the size of the real-time-data in byte */
#define MAX_RTD_SIZE 4


/**
 * @brief This structure contains all bus specific specific application data.
 *
 */
typedef struct COE_APPLICATION_EXTENDED_Ttag
{
  /** 
   * @brief EtherCAT CoE (static mapping) needs no special application data,
   * so we just place here a dummy variable.
   */
  void* pvDummy;

} COE_APPLICATION_EXTENDED_T;


/**
 * @brief This structure contains all application data.
 * It combines the common application data and the bus specific application data.
 *
 */
typedef struct COE_APPLICATION_Ttag
{
  /**
   * @brief Common application data.
   * Same for all bus systems.
   */
  APPLICATION_COMMON_T       tCommon;
	
  /**
   * @brief Extemded application data.
   * Related to the bus system and application itself, here CoE.
   */
  COE_APPLICATION_EXTENDED_T tExtended;

} COE_APPLICATION_T;


/***************************************************************************************/

/**
 *  @}
 */

#ifdef __cplusplus
  }
#endif  /* _cplusplus */


#endif /* #ifndef __COE_APPLICATION_H */
